//
// (c) 2020 wesolutions GmbH
// All rights reserved.
//

import QtQuick 2.5
import QtQuick.Dialogs 1.2

import wesual.Stage 1.0
import wesual.Ui    1.0

ContainerOption {
    id : colorOption

    property string label

    readonly property color color : colorOption.value || "black"

    defaultValue : "white"



    Column {
        property ContainerOption containerOption

        Component.onCompleted : {
            if (containerOption.colorPalette) {
                picker.palette = containerOption.colorPalette;
            }
        }

        spacing : 9

        UiLabel { text : containerOption.label }

        UiColorPicker {
            id : picker

            implicitWidth  : 365

            color    : colorOption.color
            bindable : true

            onUpdateRequested : containerOption.updateValue(newValue)
        }
    }
}
